<?php

/**
 * Realgest AJAX Class
 * 
 * Handles AJAX requests for the plugin
 */
class Realgest_AJAX {

    /**
     * API instance
     */
    private $api = null;

    /**
     * Constructor
     */
    public function __construct($api) {
        $this->api = $api;

        // Register AJAX actions
        add_action('wp_ajax_realgest_get_zones', array($this, 'get_zones'));
        add_action('wp_ajax_nopriv_realgest_get_zones', array($this, 'get_zones'));
    }

    /**
     * Get zones for a city
     */
    public function get_zones() {
        // Check city ID
        if (!isset($_POST['city_id']) || empty($_POST['city_id'])) {
            wp_send_json_error(array('message' => __('City ID is required.', 'realgest-for-wordpress')));
        }

        // Get city ID
        $city_id = intval($_POST['city_id']);

        // Get zones
        $result = $this->api->get_zones($city_id);

        if (!$result['success']) {
            wp_send_json_error(array('message' => $result['error']));
        }

        wp_send_json_success(array('zones' => $result['zones']));
    }
}
