<?php
if (!defined('ABSPATH')) exit;

/**
 * Non-breaking style registry to enable external style additions via filter.
 * The plugin will continue to work even if this class is unused.
 */
class Realgest_Style_Registry {

    public static function get_registry() {
        $registry = [
            'single' => [
                'default' => [
                    'template' => 'templates/single-property/single-property-default.php',
                    'css'      => 'assets/css/single-property/single-property-default.css',
                ],
            ],
            'search' => [
                'default' => [
                    'template' => 'templates/search/search-default.php',
                    'css'      => 'assets/css/search/search-default.css',
                ],
            ],
            'archive' => [
                'grid' => [
                    'template' => 'templates/properties/properties-grid.php',
                    'css'      => 'assets/css/properties/properties-grid.css',
                ],
                'vertical' => [
                    'template' => 'templates/properties/properties-vertical.php',
                    'css'      => 'assets/css/properties/properties-vertical.css',
                ],
            ],
        ];
        return apply_filters('realgest_styles_registry', $registry);
    }
}
