<?php
if (!defined('ABSPATH')) exit;

/**
 * Helper per enqueue CSS con possibilità di override da child theme.
 */
function realgest_enqueue_asset_css($relative_path, $handle) {
    $version = defined('REALGEST_PLUGIN_VERSION') ? REALGEST_PLUGIN_VERSION : '1.0.0';

    // Check override in theme at /realgest/<relative_path>
    $theme_rel = 'realgest/' . ltrim($relative_path, '/');
    $theme_file = locate_template($theme_rel);
    if ($theme_file && file_exists($theme_file)) {
        $theme_url = get_stylesheet_directory_uri() . '/' . ltrim($theme_rel, '/');
        wp_register_style($handle, $theme_url, [], $version);
        wp_enqueue_style($handle);
        return;
    }

    // Fallback to plugin
    $url = plugins_url($relative_path, REALGEST_PLUGIN_FILE);
    wp_register_style($handle, $url, [], $version);
    wp_enqueue_style($handle);
}
