<?php
/**
 * Template for displaying properties in a grid layout
 *
 * This template can be overridden by copying it to yourtheme/realgest/properties-grid.php
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Variables available:
// $result - Array containing 'properties', 'total', 'pages'
// $atts - Shortcode attributes
?>

<div class="realgest-properties realgest-properties-grid columns-<?php echo esc_attr($atts['columns']); ?>">
    <div class="realgest-properties-header">
        <div class="realgest-properties-count">
            <?php printf(_n('%s immobile trovato', '%s immobili trovati', $result['total'], 'realgest-for-wordpress'), number_format_i18n($result['total'])); ?>
        </div>
    </div>

    <div class="realgest-properties-list">
        <?php foreach ($result['properties'] as $property) : ?>

            <div class="realgest-property">
                <a href="<?php echo esc_url(home_url('immobili/' . $property['id'])); ?>" class="realgest-property-inner-wrapper">
                    <div class="realgest-property-inner">
                        <div class="realgest-property-thumbnail-container">
                            <?php if (!empty($property['images'])) :
                                $main_image = '';
                                foreach ($property['images'] as $image) {
                                    if ($image['is_main']) {
                                        $main_image = $image['url'];
                                        break;
                                    }
                                }
                            ?>
                                <?php if (!empty($main_image)) : ?>
                                    <div class="realgest-property-thumbnail" style="background-image: url('<?php echo esc_url($main_image); ?>');">
                                    </div>
                                <?php endif; ?>

                            <?php else : ?>
                                <div class="realgest-property-no-image"><?php _e('Nessuna immagine', 'realgest-for-wordpress'); ?></div>
                            <?php endif; ?>

                            <div class="realgest-property-badges">
                                <span class="realgest-property-badge realgest-property-badge-<?php echo sanitize_html_class(strtolower($property['offer'])); ?>">
                                    <?php echo esc_html($property['offer']); ?>
                                </span>
                            </div>
                        </div>

                        <div class="realgest-property-content">
                            <div class="realgest-property-location">
                                <span><?=esc_html($property['tipologia'])?></span>

                                <?php if (!empty($property['location']['city'])) : ?>
                                    <span class="realgest-property-city">, <?php echo esc_html($property['location']['city']); ?></span>
                                <?php endif; ?>

                                <?php if (!empty($property['location']['zone'])) : ?>
                                    <span class="realgest-property-zone">, <?php echo esc_html($property['location']['zone']); ?></span>
                                <?php endif; ?>
                            </div>

                            <?php if ($property['show_price'] && !empty($property['price'])) : ?>
                                <div class="realgest-property-price">
                                    <?php echo esc_html('€ ' . number_format($property['price'], 0, ',', '.')); ?>
                                </div>
                            <?php else: ?>
                                <div class="realgest-property-price">
                                    Trattativa riservata
                                </div>
                            <?php endif; ?>

                            <div class="realgest-property-features">
                                <?php if (!empty($property['surface'])) : ?>
                                    <div class="realgest-property-feature realgest-property-surface">
                                        <span class="realgest-property-feature-icon">
                                         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Square meters"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><path d="M8 16L16 8"/><path d="M8 12v4h4"/><path d="M16 12V8h-4"/></svg>
                                            <!--                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect></svg>-->
                                        </span>
                                        <span class="realgest-property-feature-text">
                                            <?php echo esc_html($property['surface']); ?> m²
                                        </span>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($property['rooms'])) : ?>
                                    <div class="realgest-property-feature realgest-property-rooms">
                                        <span class="realgest-property-feature-icon">
                                          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Room plan top view"><path d="M5 5H19V19H9V13H5V5Z"/><path d="M9 13H5"/><path d="M11 5H13"/></svg>
                                        </span>
                                        <span class="realgest-property-feature-text">
                                            <?php echo esc_html($property['rooms']); ?> <?php echo _n('stanza', 'stanze', $property['rooms'], 'realgest-for-wordpress'); ?>
                                        </span>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($property['bathrooms'])) : ?>
                                    <div class="realgest-property-feature realgest-property-bathrooms">
                                        <span class="realgest-property-feature-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Bathtub modern"><path d="M3 12h18v1a5 5 0 0 1-5 5H8a5 5 0 0 1-5-5v-1z"/><path d="M8 10V8a3 3 0 0 1 3-3h2"/><path d="M6 21h2"/><path d="M16 21h2"/></svg>
<!--                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16v2H4zM4 14h16v2H4zM9 4v16M4 9h16M4 19h16"></path></svg>-->
                                        </span>
                                        <span class="realgest-property-feature-text">
                                            <?php echo esc_html($property['bathrooms']); ?> <?php echo _n('bagno', 'bagni', $property['bathrooms'], 'realgest-for-wordpress'); ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="realgest-property-description">
                                <?php echo wp_trim_words($property['description'], 50, '...'); ?>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
</div>
