<?php
/**
 * Template for displaying property search form
 *
 * This template can be overridden by copying it to yourtheme/realgest/search-default.php
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Variables available:
// $offer_types - Array of offer types (sale/rent)
// $property_types - Array of property types
// $cities - Array of cities
// $atts - Shortcode attributes

// Check if variables are defined
if (!isset($atts) || !is_array($atts)) {
    return;
}
?>

<div class="realgest-search">
    <form action="<?php echo esc_url($atts['action'] ? $atts['action'] : get_permalink()); ?>" method="get" class="realgest-search-form">
        <?php if ($atts['show_offer_types'] && !empty($offer_types)) : ?>
            <div class="realgest-search-field realgest-search-offer-types">
                <label for="realgest-offer"><?php _e('Tipo di Offerta', 'realgest-for-wordpress'); ?></label>
                <select name="offer" id="realgest-offer">
                    <option value=""><?php _e('Qualsiasi', 'realgest-for-wordpress'); ?></option>
                    <?php foreach ($offer_types as $type) : ?>
                        <option value="<?php echo esc_attr($type['id']); ?>" <?php selected(isset($_GET['offer']) ? $_GET['offer'] : '', $type['id']); ?>>
                            <?php echo esc_html($type['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_property_types'] && !empty($property_types)) : ?>
            <div class="realgest-search-field realgest-search-property-types">
                <label for="realgest-type"><?php _e('Tipologia Immobile', 'realgest-for-wordpress'); ?></label>
                <select name="type" id="realgest-type">
                    <option value=""><?php _e('Qualsiasi', 'realgest-for-wordpress'); ?></option>
                    <?php foreach ($property_types as $type) : ?>
                        <option value="<?php echo esc_attr($type['id']); ?>" <?php selected(isset($_GET['type']) ? $_GET['type'] : '', $type['id']); ?>>
                            <?php echo esc_html($type['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_cities'] && !empty($cities)) : ?>
            <div class="realgest-search-field realgest-search-cities">
                <label for="realgest-city"><?php _e('Città', 'realgest-for-wordpress'); ?></label>
                <select name="city" id="realgest-city" class="realgest-city-select">
                    <option value=""><?php _e('Qualsiasi', 'realgest-for-wordpress'); ?></option>
                    <?php foreach ($cities as $city) : ?>
                        <option value="<?php echo esc_attr($city['id']); ?>" <?php selected(isset($_GET['city']) ? $_GET['city'] : '', $city['id']); ?>>
                            <?php echo esc_html($city['name']); ?> (<?php echo esc_html($city['province_code']); ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_zones']) : ?>
            <div class="realgest-search-field realgest-search-zones">
                <label for="realgest-zone"><?php _e('Zona', 'realgest-for-wordpress'); ?></label>
                <select name="zone" id="realgest-zone" class="realgest-zone-select" disabled>
                    <option value=""><?php _e('Qualsiasi', 'realgest-for-wordpress'); ?></option>
                </select>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_price']) : ?>
            <div class="realgest-search-field realgest-search-price">
                <label for="realgest-price-min"><?php _e('Fascia di Prezzo', 'realgest-for-wordpress'); ?></label>
                <div class="realgest-search-range">
                    <input type="number" name="price_min" id="realgest-price-min" placeholder="<?php _e('Min', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['price_min']) ? esc_attr($_GET['price_min']) : ''; ?>">
                    <span class="realgest-search-range-separator">-</span>
                    <input type="number" name="price_max" id="realgest-price-max" placeholder="<?php _e('Max', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['price_max']) ? esc_attr($_GET['price_max']) : ''; ?>">
                </div>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_surface']) : ?>
            <div class="realgest-search-field realgest-search-surface">
                <label for="realgest-surface-min"><?php _e('Fascia di Superficie (m²)', 'realgest-for-wordpress'); ?></label>
                <div class="realgest-search-range">
                    <input type="number" name="surface_min" id="realgest-surface-min" placeholder="<?php _e('Min', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['surface_min']) ? esc_attr($_GET['surface_min']) : ''; ?>">
                    <span class="realgest-search-range-separator">-</span>
                    <input type="number" name="surface_max" id="realgest-surface-max" placeholder="<?php _e('Max', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['surface_max']) ? esc_attr($_GET['surface_max']) : ''; ?>">
                </div>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_rooms']) : ?>
            <div class="realgest-search-field realgest-search-rooms">
                <label for="realgest-rooms-min"><?php _e('Stanze', 'realgest-for-wordpress'); ?></label>
                <div class="realgest-search-range">
                    <input type="number" name="rooms_min" id="realgest-rooms-min" placeholder="<?php _e('Min', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['rooms_min']) ? esc_attr($_GET['rooms_min']) : ''; ?>">
                    <span class="realgest-search-range-separator">-</span>
                    <input type="number" name="rooms_max" id="realgest-rooms-max" placeholder="<?php _e('Max', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['rooms_max']) ? esc_attr($_GET['rooms_max']) : ''; ?>">
                </div>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_bathrooms']) : ?>
            <div class="realgest-search-field realgest-search-bathrooms">
                <label for="realgest-bathrooms-min"><?php _e('Bagni', 'realgest-for-wordpress'); ?></label>
                <div class="realgest-search-range">
                    <input type="number" name="bathrooms_min" id="realgest-bathrooms-min" placeholder="<?php _e('Min', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['bathrooms_min']) ? esc_attr($_GET['bathrooms_min']) : ''; ?>">
                    <span class="realgest-search-range-separator">-</span>
                    <input type="number" name="bathrooms_max" id="realgest-bathrooms-max" placeholder="<?php _e('Max', 'realgest-for-wordpress'); ?>" value="<?php echo isset($_GET['bathrooms_max']) ? esc_attr($_GET['bathrooms_max']) : ''; ?>">
                </div>
            </div>
        <?php endif; ?>

        <?php if ($atts['show_features']) : ?>
            <div class="realgest-search-field realgest-search-features">
                <label><?php _e('Caratteristiche', 'realgest-for-wordpress'); ?></label>
                <div class="realgest-search-features-list">
                    <div class="realgest-search-feature">
                        <input type="checkbox" name="garden" id="realgest-garden" value="1" <?php checked(isset($_GET['garden']) ? $_GET['garden'] : '', '1'); ?>>
                        <label for="realgest-garden"><?php _e('Giardino', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="terrace" id="realgest-terrace" value="1" <?php checked(isset($_GET['terrace']) ? $_GET['terrace'] : '', '1'); ?>>
                        <label for="realgest-terrace"><?php _e('Terrazzo', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="balcony" id="realgest-balcony" value="1" <?php checked(isset($_GET['balcony']) ? $_GET['balcony'] : '', '1'); ?>>
                        <label for="realgest-balcony"><?php _e('Balcone', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="elevator" id="realgest-elevator" value="1" <?php checked(isset($_GET['elevator']) ? $_GET['elevator'] : '', '1'); ?>>
                        <label for="realgest-elevator"><?php _e('Ascensore', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="cellar" id="realgest-cellar" value="1" <?php checked(isset($_GET['cellar']) ? $_GET['cellar'] : '', '1'); ?>>
                        <label for="realgest-cellar"><?php _e('Cantina', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="air_conditioning" id="realgest-air-conditioning" value="1" <?php checked(isset($_GET['air_conditioning']) ? $_GET['air_conditioning'] : '', '1'); ?>>
                        <label for="realgest-air-conditioning"><?php _e('Aria Condizionata', 'realgest-for-wordpress'); ?></label>
                    </div>

                    <div class="realgest-search-feature">
                        <input type="checkbox" name="furnished" id="realgest-furnished" value="1" <?php checked(isset($_GET['furnished']) ? $_GET['furnished'] : '', '1'); ?>>
                        <label for="realgest-furnished"><?php _e('Arredato', 'realgest-for-wordpress'); ?></label>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="realgest-search-field realgest-search-submit">
            <button type="submit" class="realgest-search-button"><?php _e('Cerca', 'realgest-for-wordpress'); ?></button>
        </div>
    </form>

    <script>
        jQuery(document).ready(function($) {
            // Handle city change to load zones
            $('.realgest-city-select').on('change', function() {
                var cityId = $(this).val();
                var zoneSelect = $('.realgest-zone-select');

                if (cityId) {
                    // Enable zone select
                    zoneSelect.prop('disabled', false);

                    // Clear current options
                    zoneSelect.find('option:not(:first)').remove();

                    // Show loading
                    zoneSelect.after('<span class="realgest-loading"><?php _e('Caricamento...', 'realgest-for-wordpress'); ?></span>');

                    // Load zones via AJAX
                    $.ajax({
                        url: realgest_params.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'realgest_get_zones',
                            city_id: cityId
                        },
                        success: function(response) {
                            // Remove loading
                            $('.realgest-loading').remove();



                            if (response.success && response.data.zones) {
                                // Add new options
                                $.each(response.data.zones, function(index, zone) {
                                    console.log(zone);
                                    zoneSelect.append($('<option>', {
                                        value: zone.id,
                                        text: zone.name
                                    }));
                                });
                            }
                        },
                        error: function() {
                            // Remove loading
                            $('.realgest-loading').remove();
                        }
                    });
                } else {
                    // Disable zone select
                    zoneSelect.prop('disabled', true);
                    zoneSelect.find('option:not(:first)').remove();
                }
            });
        });
    </script>
</div>
