<?php
/**
 * Template for displaying a single property page
 *
 * This template is used when a user visits a property detail page via the URL rewrite rules.
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get property ID from query var
$property_id = get_query_var('realgest_property');

// Get Realgest plugin instance
$realgest = realgest_for_wordpress();

// Get property by ID
$result = $realgest->api->get_property($property_id);

// Check if property exists
if (!$result['success'] || empty($result['property'])) {
    get_header();
    ?>
    <div class="realgest-error">
        <?php _e('Immobile non trovato.', 'realgest-for-wordpress'); ?>
    </div>
    <?php
    get_footer();
    return;
}

// Get property
$property = $result['property'];

// Set page title
add_filter('pre_get_document_title', function($title) use ($property) {
    return $property['title'] . ' - ' . get_bloginfo('name');
});

// Add meta tags
add_action('wp_head', function() use ($property) {
    // Description
    echo '<meta name="description" content="' . esc_attr(wp_trim_words($property['description'], 30, '...')) . '">';
    // Open Graph
    echo '<meta property="og:title" content="' . esc_attr($property['title']) . '">';
    echo '<meta property="og:description" content="' . esc_attr(wp_trim_words($property['description'], 30, '...')) . '">';

    // If property has images
    if (!empty($property['images'])) {
        // Find main image
        $main_image = '';
        foreach ($property['images'] as $image) {
            if ($image['is_main']) {
                $main_image = $image['url'];
                break;
            }
        }

        // If no main image, use first image
        if (empty($main_image) && !empty($property['images'][0]['url'])) {
            $main_image = $property['images'][0]['url'];
        }

        if (!empty($main_image)) {
            echo '<meta property="og:image" content="' . esc_url($main_image) . '">';
        }
    }
});

// Get header
get_header();
?>
<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <?php require_once REALGEST_PLUGIN_DIR . 'templates/single-property/single-property-default.php'; ?>
    </main>
</div>

<?php

wp_register_style(
        'realgest-styles',
        REALGEST_PLUGIN_URL . 'assets/css/single-property/single-property-default.css' ,
        array(),
        REALGEST_PLUGIN_VERSION
);
wp_enqueue_style('realgest-styles');
// Get footer
get_footer();

