<?php
/**
 * Template for displaying a single property
 *
 * This template can be overridden by copying it to yourtheme/realgest/property-default.php
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Variables available:
// $property - Property data

// Check if property variable is defined
if (!isset($property) || !is_array($property)) {
    return;
}
?>
<div class="realgest-property-single">
    <div class="realgest-property-header">
        <h1 class="realgest-property-title"><?php echo esc_html($property['title']); ?></h1>

        <div class="realgest-property-location">
            <?php if (!empty($property['location']['address'])) : ?>
                <span class="realgest-property-address"><?php echo esc_html($property['location']['address']); ?></span>
            <?php endif; ?>

            <?php if (!empty($property['location']['number'])) : ?>
                <span class="realgest-property-number"><?php echo esc_html($property['location']['number']); ?></span>
            <?php endif; ?>

            <?php if (!empty($property['location']['city'])) : ?>
                <span class="realgest-property-city"><?php echo esc_html($property['location']['city']); ?></span>
            <?php endif; ?>

            <?php if (!empty($property['location']['province'])) : ?>
                <span class="realgest-property-province">(<?php echo esc_html($property['location']['province']); ?>)</span>
            <?php endif; ?>

            <?php if (!empty($property['location']['zone'])) : ?>
                <span class="realgest-property-zone"><?php echo esc_html($property['location']['zone']); ?></span>
            <?php endif; ?>
        </div>

        <div class="realgest-property-meta">
            <div class="realgest-property-reference">
                <b><?php _e('Rif:', 'realgest-for-wordpress'); ?></b> <?php echo esc_html($property['reference']); ?>
            </div>

            <?php if ($property['show_price'] && !empty($property['price'])) : ?>
                <div class="realgest-property-price">
                    <?php echo esc_html('€ ' . number_format($property['price'], 0, ',', '.')); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="realgest-property-gallery" data-rg-gallery>
        <?php if (!empty($property['images'])) : ?>
            <?php
            $images = array_values(array_filter($property['images'], function($i){
                return !empty($i['url']);
            }));
            $main_index = 0;
            foreach ($images as $i => $img) {
                if (!empty($img['is_main'])) { $main_index = $i; break; }
            }
            $main_image = $images[$main_index]['url'] ?? '';
            ?>

            <div class="realgest-property-gallery-main" data-rg-main data-index="<?php echo esc_attr($main_index); ?>">
                <?php if (!empty($main_image)) : ?>
                    <div class="realgest-property-gallery-main-image"
                         data-rg-main-img
                         style="background-image:url('<?php echo esc_url($main_image); ?>');"
                         role="img"
                         aria-label="<?php echo esc_attr($property['title']); ?>"></div>
                <?php endif; ?>

                <?php if (count($images) > 1) : ?>
                    <button type="button" class="realgest-nav realgest-prev" aria-label="<?php esc_attr_e('Immagine precedente','realgest-for-wordpress'); ?>" data-rg-prev>&#10094;</button>
                    <button type="button" class="realgest-nav realgest-next" aria-label="<?php esc_attr_e('Immagine successiva','realgest-for-wordpress'); ?>" data-rg-next>&#10095;</button>
                <?php endif; ?>
            </div>

            <?php if (count($images) > 1) : ?>
                <div class="realgest-property-gallery-thumbnails" data-rg-thumbs>
                    <?php foreach ($images as $i => $image) : ?>
                        <div class="realgest-property-gallery-thumbnail"
                             data-rg-thumb
                             data-index="<?php echo esc_attr($i); ?>"
                             style="background-image:url('<?php echo esc_url($image['url']); ?>');"
                             role="img"
                             aria-label="<?php echo esc_attr($image['title'] ?? $property['title']); ?>"></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php else : ?>
            <div class="realgest-property-no-image"><?php _e('Nessuna immagine disponibile', 'realgest-for-wordpress'); ?></div>
        <?php endif; ?>
    </div>

    <?php if(!empty($property['description']) || !empty($property['extended_description'])): ?>
        <div class="realgest-property-description">
            <h3><?php _e('Descrizione', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-description-content">
                <?php echo $description = !empty($property['extended_description']) ? $property['extended_description'] : $property['description']; ?>
            </div>
        </div>
    <?php endif; ?>


    <?php if ( !empty($property['surface']) || !empty($property['rooms']) || !empty($property['bathrooms']) || !empty($property['energy_class']) || !empty($property['ipe']) )  : ?>

        <div class="realgest-property-features">
            <h3><?php _e('Dettagli Immobile', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-features-list">

                <?php if (!empty($property['type'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="House simple"><path d="M3 11l9-7 9 7"/><path d="M5 11v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-8"/><path d="M10 21v-6h4v6"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Tipologia', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['type']); ?></span>
                                </span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($property['offer'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Offer label flag"><path d="M6 5v14"/><path d="M6 8h10l2 2-2 2H6V8z"/><path d="M4 19h16"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Offerta', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['offer']); ?></span>
                                </span>
                    </div>
                <?php endif; ?>


                <?php if (!empty($property['surface'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Square meters"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><path d="M8 16L16 8"/><path d="M8 12v4h4"/><path d="M16 12V8h-4"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Superficie', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['surface']); ?> m²</span>
                                </span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($property['rooms'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Room plan top view"><path d="M5 5H19V19H9V13H5V5Z"/><path d="M9 13H5"/><path d="M11 5H13"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Stanze', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['rooms']); ?></span>
                                </span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($property['bathrooms'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Bathtub modern"><path d="M3 12h18v1a5 5 0 0 1-5 5H8a5 5 0 0 1-5-5v-1z"/><path d="M8 10V8a3 3 0 0 1 3-3h2"/><path d="M6 21h2"/><path d="M16 21h2"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Bagni', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['bathrooms']); ?></span>
                                </span>

                    </div>
                <?php endif; ?>

                <?php if (!empty($property['energy_class'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Energy efficiency gauge"><path d="M3 11l9-7 9 7v7a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3v-7z"/><path d="M8 15a4 4 0 0 1 8 0"/><path d="M12 15l3-2"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('Classe Energetica', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value-energetic">
                                        <?php
                                            $path_classenergetica = REALGEST_PLUGIN_DIR . 'assets/images/energy-class/' . strtolower($property['energy_class']) . '.png';
                                            $url_classenergetica = REALGEST_PLUGIN_URL . 'assets/images/energy-class/' . strtolower($property['energy_class']) . '.png';
                                            if(file_exists($path_classenergetica)){
                                                ?>
                                                    <img src="<?= esc_url($url_classenergetica) ?>" alt="<?php _e('Classe Energetica', 'realgest-for-wordpress'); ?>">
                                                <?php
                                            }else{
                                                echo $property['energy_class'];
                                            }
                                        ?>
                                    </span>
                                </span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($property['ipe'])) : ?>
                    <div class="realgest-property-feature">
                                <span class="realgest-property-feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Square meters"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><path d="M8 16L16 8"/><path d="M8 12v4h4"/><path d="M16 12V8h-4"/></svg>
                                </span>
                        <span class="realgest-property-feature-text">
                                    <span class="realgest-property-feature-label"><?php _e('IPE', 'realgest-for-wordpress'); ?></span>
                                    <span class="realgest-property-feature-value"><?php echo esc_html($property['ipe']); ?></span>
                                </span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if ( $property['features']['garden'] || $property['features']['terrace'] || $property['features']['balcony'] || $property['features']['elevator'] || $property['features']['cellar'] || $property['features']['air_conditioning'] || $property['features']['furnished'] )  : ?>

        <div class="realgest-property-amenities">
            <h3><?php _e('Servizi', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-amenities-list">
                <?php if ($property['features']['garden']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Pine tree"><path d="M12 3l-6 8h12l-6-8z"/><path d="M8 11l-4 6h16l-4-6z"/><path d="M12 17v4"/></svg>
<!--                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>-->
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Giardino', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['terrace']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line><line x1="3" y1="15" x2="21" y2="15"></line></svg>
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Terrazzo', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['balcony']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line></svg>
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Balcone', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['elevator']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Elevator"><rect x="6" y="4" width="12" height="16" rx="1" ry="1"/><path d="M12 8l-2 2h4l-2-2z"/><path d="M12 16l2-2h-4l2 2z"/></svg>
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Ascensore', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['cellar']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Cantina', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['air_conditioning']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Air flow"><path d="M4 10h10a2 2 0 1 0 0-4"/><path d="M4 14h12a2 2 0 1 1 0 4"/></svg>

                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Aria Condizionata', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>

                <?php if ($property['features']['furnished']) : ?>
                    <div class="realgest-property-amenity">
                    <span class="realgest-property-amenity-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-label="Wardrobe"><rect x="6" y="4" width="12" height="16" rx="1" ry="1"/><path d="M12 4v16"/><circle cx="10" cy="12" r="0.5"/><circle cx="14" cy="12" r="0.5"/></svg>
                    </span>
                        <span class="realgest-property-amenity-text"><?php _e('Arredato', 'realgest-for-wordpress'); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($property['location']['show_map'] && !empty($property['location']['latitude']) && !empty($property['location']['longitude'])) : ?>
        <div class="realgest-property-map">
            <h3><?php _e('Posizione', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-map-container" id="realgest-property-map" data-lat="<?php echo esc_attr($property['location']['latitude']); ?>" data-lng="<?php echo esc_attr($property['location']['longitude']); ?>"></div>

            <script>
                function initRealgestMap() {
                    var mapContainer = document.getElementById('realgest-property-map');
                    var lat = parseFloat(mapContainer.getAttribute('data-lat'));
                    var lng = parseFloat(mapContainer.getAttribute('data-lng'));

                    var map = new google.maps.Map(mapContainer, {
                        center: {lat: lat, lng: lng},
                        zoom: 15
                    });

                    var marker = new google.maps.Marker({
                        position: {lat: lat, lng: lng},
                        map: map
                    });


                }
            </script>
            <script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr(get_option('realgest_google_maps_api_key', '')); ?>&callback=initRealgestMap"></script>

        </div>
    <?php endif; ?>

    <?php if (!empty($property['videos']) && is_array($property['videos'])) : ?>
        <?php
        // Filter out empty videos
        $videos = array_filter($property['videos']);

        if (!empty($videos)) :
            ?>
            <div class="realgest-property-videos">
                <h3><?php _e('Video', 'realgest-for-wordpress'); ?></h3>

                <div class="realgest-property-videos-list">
                    <?php foreach ($videos as $video) : ?>
                        <div class="realgest-property-video">
                            <?php
                            // Extract video ID from YouTube URL
                            $video_id = '';
                            if (preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/', $video, $matches)) {
                                $video_id = $matches[1];
                            }

                            if (!empty($video_id)) :
                                ?>
                                <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo esc_attr($video_id); ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            <?php else : ?>
                                <a href="<?php echo esc_url($video); ?>" target="_blank"><?php _e('Guarda il video', 'realgest-for-wordpress'); ?></a>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (!empty($property['virtual_tour'])) : ?>
        <div class="realgest-property-virtual-tour">
            <h3><?php _e('Tour Virtuale', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-virtual-tour-container">
                <iframe src="<?php echo esc_url($property['virtual_tour']); ?>" width="100%" height="500" frameborder="0" allowfullscreen></iframe>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($property['floor_plan'])) : ?>
        <div class="realgest-property-floor-plan">
            <h3><?php _e('Planimetria', 'realgest-for-wordpress'); ?></h3>

            <div class="realgest-property-floor-plan-container">
                <img src="<?php echo esc_url($property['floor_plan']); ?>" alt="<?php _e('Planimetria', 'realgest-for-wordpress'); ?>" class="realgest-property-floor-plan-image">
            </div>
        </div>
    <?php endif; ?>
</div>